//
//  OPItemList.h
//  OnePasswordiOS
//
//  Created by Roustem Karimov on 2012-08-19.
//  Copyright (c) 2012 AgileBits. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <OnePasswordDataModel/OPItem.h>

@class OPDatabaseOperation;

@interface OPItemListSection : NSObject <NSCopying, NSMutableCopying>

@property (nonatomic, strong) NSString * sectionName;
@property (nonatomic, strong) NSArray * items;

- (void)addItem:(OPItem *)item;
- (OPItem *)itemAtIndex:(NSUInteger)index;
- (NSUInteger)indexOfItemWithId:(OPID)oid;
- (NSUInteger)numberOfItems;

- (void)removeItemAtIndex:(NSUInteger)index;
- (void)sortItemsByTitle;

@end

@interface OPItemList : NSObject <NSCopying, NSMutableCopying>

@property (nonatomic) OPID categoryId;
@property (nonatomic, strong) NSArray * sections;
@property (nonatomic, readonly) NSArray * sectionIndexTitles;
@property (nonatomic, readonly, getter = isEmpty) BOOL empty;
@property (nonatomic) BOOL showsSearchSection;

- (void)sortContentsByLocalizedCaseInsensitive;
- (void)sortSectionsByName;

- (void)addItem:(OPItem *)item;
- (void)addItemToSearchSection:(OPItem *)item; // If showsSearchSection is YES, this method will add an item to that section.
- (OPItem *)itemAtIndexPath:(NSIndexPath *)indexPath;
- (NSIndexPath *)indexPathForItemWithId:(OPID)itemId;
- (NSIndexPath *)indexPathForItemWithUUID:(NSString *)itemUUID;
- (void)enumerateItemsUsingBlock:(void (^)(OPItem *item))block;
- (void)enumerateItemsUsingCancelableBlock:(void (^)(OPItem *itemProxy, BOOL *canceled))block;
- (NSUInteger)indexOfSectionWithName:(NSString *)sectionName;
- (NSInteger)sectionForSectionIndexTitle:(NSString *)title atIndex:(NSInteger)index;
- (NSUInteger)numberOfItems;

- (OPItem *)itemWithId:(OPID)itemId;
- (void)removeSectionAtIndex:(NSUInteger)index;
- (void)removeItemAtIndexPath:(NSIndexPath *)indexPath;

- (void)randomlyRemoveAndShuffleItemsAndSectionsForTesting;

@end
